/*
 *  SecuDE Release 4.1 (GMD)
 */
/********************************************************************
 * Copyright (C) 1991, GMD. All rights reserved.                    *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

#include "secure.h"
#include <stdio.h>
#ifdef MAC
#include <stdlib.h>
#include <string.h>
#endif

extern OctetString *aux_de64() ,   *aux_encrfc() , *aux_decrfc() ,
*aux_enchex() , *aux_dechex();
extern int	errno;



/************************************************************************/
/*                                                                      */
/*    aux_fprint_OctetString, aux_fprint_BitString                      */
/*                                                                      */
/*    prints given OctetString/BitString in a dump format to ff         */
/*                                                                      */
/*                                                                      */
/************************************************************************/
void aux_fprint_OctetString(ff, ostr)
FILE                 *ff;
OctetString          *ostr;
{
	if(!ostr) return;
	fprintf(ff, "OctetString length: %d octets\n", ostr->noctets);
	if(ostr->noctets) {
		fprintf(ff, "OctetString:\n");
		aux_fxdump(ff, ostr->octets, ostr->noctets, 0);
	}
}

void aux_fprint_BitString(ff, bstr)
FILE                 *ff;
BitString            *bstr;
{
	if(!bstr) return;
	fprintf(ff, "BitString length: %d bits\n", bstr->nbits);
	if(bstr->nbits) {
		fprintf(ff, "BitString:\n");
		aux_fxdump(ff, bstr->bits, (bstr->nbits + 7)/8, 0);
	}
}

/************************************************************************/
/*                                                                      */
/*      aux_create_OctetString                                          */
/*                                                                      */
/*      erzeugt octetstring und initialisiert ihn mit text              */
/*                                                                      */
/*                                                                      */
/************************************************************************/
OctetString * aux_create_OctetString( text )
char	*text;
{
	unsigned int	   n;
	OctetString      * bst;
	char		 * proc = "aux_create_OctetString";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!(bst = (OctetString * ) malloc( sizeof( OctetString ) ))) {
		aux_add_error(EMALLOC, "bst", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}
	bst->noctets = text ? strlen( text ) : 0;
	if ( bst->noctets ) {
		bst->octets = (char * ) calloc( 1 , bst->noctets );
		if ( !bst->octets ) {
			free( bst );
			aux_add_error(EMALLOC, "bst->octets", CNULL, 0, proc);
			return (NULLOCTETSTRING);
		}
	}
	for ( n = 0 ; n < bst->noctets ; n++) 
		bst->octets[n] = text[n];

	return( bst );
}

/************************************************************************/
/*                                                                      */
/*      aux_new_OctetString                                             */
/*                                                                      */
/*      erzeugt octetstring und initialisiert ihn mit zeros             */
/*                                                                      */
/*                                                                      */
/************************************************************************/
OctetString * aux_new_OctetString(length)
int length;
{
	unsigned int	   n;
	OctetString      * ostr;
	char		 * proc = "aux_new_OctetString";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!(ostr = (OctetString * ) malloc( sizeof( OctetString ) ))) {
		aux_add_error(EMALLOC, "ostr", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}
	ostr->noctets = length;
	if ( length > 0 ) {
		ostr->octets = (char * ) calloc( 1 , length );
		if ( !ostr->octets ) {
			free( ostr );
			aux_add_error(EMALLOC, "ostr->octets", CNULL, 0, proc);
			return (NULLOCTETSTRING);
		}
	}
	else ostr->octets = CNULL;

	return ( ostr );
}


/************************************************************************/
/*                                                                      */
/*      aux_append_OctetString                                          */
/*                                                                      */
/*      haengt octetstring append an octetstream to an                  */
/*                                                                      */
/*                                                                      */
/************************************************************************/
RC aux_append_OctetString( to , append )
OctetString          *to,
*append;
{
	char		* add;
	unsigned int	  n;
	char		* proc = "aux_append_OctetString";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( !to ) {
		aux_add_error(EINVALID, "to empty", CNULL, 0, proc);
		return(-1);
	}
	if ( !append ) 
		return( 0 );    /* nichts anhaengen */

	if (!(add = (char * )calloc( 1 , to->noctets + append->noctets ))) {
		aux_add_error(EMALLOC, "add", CNULL, 0, proc);
		return(-1);
	}


	for ( n = 0 ; n < to->noctets ; n++)
		add[n] = to->octets[n]; /* to kopieren  */

	for ( n = 0 ; n < append->noctets ; n++)
		add[to->noctets++] = append->octets[n]; /*append kopieren*/

	if(to->octets) free(to->octets); /*alten speicherplatz freigeben */

	to->octets = add;


	return(0);
}


/************************************************************************/
/*                                                                      */
/*      aux_append_char                                                 */
/*                                                                      */
/*      haengt char*  an octetstring an                                 */
/*                                                                      */
/*                                                                      */
/************************************************************************/

RC aux_append_char( to , append )
OctetString          *to;
char	*append;
{
	char		* add;
	unsigned int	  n, len;
	char		* proc = "aux_append_char";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( !to ) {
		aux_add_error(EINVALID, "to empty", CNULL, 0, proc);
		return(-1);
	}
	if ( !append ) 
		return( 0 );    /* nichts anhaengen */
	len = strlen( append );

	if (!(add = (char * ) calloc( 1 , to->noctets + len ))) {
		aux_add_error(EMALLOC, "add", CNULL, 0, proc);
		return(-1);
	}


	for ( n = 0 ; n < to->noctets ; n++)
		add[n] = to->octets[n]; /* to kopieren  */

	for ( n = 0 ; n < len ; n++)
		add[to->noctets++] = append[n]; /*append kopieren*/

	if(to->octets) free(to->octets); /*alten speicherplatz freigeben */

	to->octets = add;


	return(0);
}


/************************************************************************/
/*                                                                      */
/*    aux_hex_append                                                    */
/*                                                                      */
/*    haengt octetstring append in HEX-darstellung an octetstring to an */
/*                                                                      */
/*                                                                      */
/************************************************************************/
RC aux_hex_append( to , append )
OctetString           *to,
*append;
{
	OctetString       * hexstr;
	int		    ec;
	char		  * proc = "aux_hex_append";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	/*----------------------------------------------------------------------*/
	if (!(hexstr = aux_enchex( append ))) {
		aux_add_error(EINVALID, "aux_enchex failed", CNULL, 0, proc);
		return(-1);
	}

	if (( ec = aux_append_OctetString( to , hexstr )) ) {/*----------------------------------------------------------------------*/

		aux_add_error(EINVALID, "aux_append_OctetString failed", CNULL, 0, proc);
		aux_free_OctetString( &hexstr );
		return( ec );
	}
	aux_free_OctetString( &hexstr );
	return( 0 );
}



/************************************************************************/
/*                                                                      */
/*      aux_searchitem                                                  */
/*                                                                      */
/*      sucht in octetstring bst nach string item beginnend bei         */
/*      *pos. bei returncode 0 war die suche erfolgreich und *pos       */
/*      ist die position des ersten zeichens nach item                  */
/*      nicht gefunden: rc=-1                                           */
/*                                                                      */
/*                                                                      */
/************************************************************************/
RC aux_searchitem( bst , item , pos )
OctetString  * bst;
char	     * item;
unsigned int * pos;
{
	char		incs[256];
	unsigned int	le, n, m, l;
	char		c, * text;
	char	      * proc = "aux_searchitem";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif	

	if ( !bst || !item || !pos ) {
		aux_add_error(EINVALID, "one parameter = 0", CNULL, 0, proc);
		return(-1);
	}


	text = bst->octets;

	le = strlen( item );

	for ( n = 0 ; n < 256 ; n++) 
		incs[ n ] = le;
	for ( n = le - 1 ; n > 0 ; n--) {
		c = item[ n - 1 ];
		if ( incs[ c ] == le )
			incs[ c ] = le - n;
	}

	n = le - 1 + *pos;
	l = bst->noctets;
	while ( n < l ) {

		for ( m = le ; m > 0 && item[ m - 1 ] == text[ n + m - le ] ; m--) 
			;
		if ( !m ) {
			*pos = n + 1;
			return( 0 );
		} else
			n += incs[ (unsigned char)text[ n ] ];
	}

	return (-1);

}


/************************************************************************/
/*                                                                      */
/*      aux_ostr_get64                                                  */
/*                                                                      */
/*      holt den text von pos ab bis zum naechsten X-Header-Feld        */
/*      aus dem msgbuf wobei erwartet wird das jede zeile 64 zeichen    */
/*      enthaelt und das erste zeichen ein leerzeichen ist              */
/*                                                                      */
/************************************************************************/
OctetString * aux_ostr_get64( msgbuf , pos )
OctetString * msgbuf;
int	      pos;
{
	int		  n, m;
	OctetString       text64, *text;   /*return*/
	char		* proc = "aux_ostr_get64";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	m = msgbuf->noctets - 1;
	for ( n = pos; n < m; n++) {
		if (msgbuf->octets[n] == '\n') {
			if (msgbuf->octets[n+1] != ' ')
				break;
		}
	}
	text64.noctets = n - pos;
	text64.octets = msgbuf->octets + pos;
	if ( text64.octets[text64.noctets - 1] == '\r' )
		text64.noctets--;

	if (!(text = aux_de64(&text64 , 1))) {
		aux_add_error(EINVALID, "aux_de64 failed", CNULL, 0, proc);
		return (NULLOCTETSTRING);
	}


	return( text );
}


/************************************************************************/
/*                                                                      */
/*      aux_cmpitem                                                     */
/*                                                                      */
/*      vergleicht item mit dem text in msgbuf bei position pos         */
/*      bei returncode 0 sind die texte gleich                          */
/*                                                                      */
/************************************************************************/
RC aux_cmpitem( msgbuf , item , pos )
OctetString * msgbuf;
char	    * item;
int	      pos;
{
	int	  n, le;
	char	* proc = "aux_cmpitem";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!msgbuf || !item ) {
		aux_add_error(EINVALID, "one parameter = 0", CNULL, 0, proc);
		return(-1);
	}

	le = strlen( item );

	for ( n = 0 ; n < le ; n++)
		if ( msgbuf->octets[ n + pos ] != item[ n ] )  
			return( 1 );

	return( 0 );
}


